package ru.yandex.stockpile.cluster.balancer.client;

import java.util.Set;
import java.util.concurrent.CompletableFuture;

import ru.yandex.stockpile.internal.api.TAssignShardRequest;
import ru.yandex.stockpile.internal.api.TAssignShardResponse;
import ru.yandex.stockpile.internal.api.TListAssignmentsRequest;
import ru.yandex.stockpile.internal.api.TListAssignmentsResponse;
import ru.yandex.stockpile.internal.api.TPingRequest;
import ru.yandex.stockpile.internal.api.TPingResponse;
import ru.yandex.stockpile.internal.api.TUnassignShardRequest;
import ru.yandex.stockpile.internal.api.TUnassignShardResponse;

/**
 * @author Vladimir Gordiychuk
 */
public interface StockpileBalancerClient {

    /**
     * @return list available nodes in the cluster
     */
    Set<String> getNodes();

    /**
     * Leader -> Node
     * <p>
     * Assign particular shard on current node
     */
    CompletableFuture<TAssignShardResponse> assignShard(String node, TAssignShardRequest request);

    /**
     * Leader -> Node
     * <p>
     * Unassign particular shard from current node
     * <p>
     * Force unassign:<br/>
     * 1) Stop shard processing as fast as possible<br/>
     * <p>
     * Graceful unassign:<br/>
     * 1) Complete in-flight writes<br/>
     * 2) Make logs snapshots to speed up a start-up on the another node<br/>
     * 3) Reply about successful unassign<br/>
     */
    CompletableFuture<TUnassignShardResponse> unassignShard(String node, TUnassignShardRequest request);

    /**
     * Node -> Leader
     * <p>
     * Ask assignments for node from leader, useful when application restarted
     */
    CompletableFuture<TListAssignmentsResponse> listAssignments(String leader, TListAssignmentsRequest request);

    /**
     * Leader -> Node
     * <p>
     * Get latest status of assigned shards
     */
    CompletableFuture<TPingResponse> ping(String node, TPingRequest request);
}
