package ru.yandex.stockpile.cluster.balancer.server;

import io.grpc.stub.StreamObserver;

import ru.yandex.grpc.utils.InternalGrpcService;
import ru.yandex.grpc.utils.StreamObservers;
import ru.yandex.stockpile.cluster.balancer.StockpileLocalShardsState;
import ru.yandex.stockpile.internal.api.TAssignShardRequest;
import ru.yandex.stockpile.internal.api.TAssignShardResponse;
import ru.yandex.stockpile.internal.api.TListAssignmentsRequest;
import ru.yandex.stockpile.internal.api.TListAssignmentsResponse;
import ru.yandex.stockpile.internal.api.TPingRequest;
import ru.yandex.stockpile.internal.api.TPingResponse;
import ru.yandex.stockpile.internal.api.TStockpileBalancerServiceGrpc;
import ru.yandex.stockpile.internal.api.TUnassignShardRequest;
import ru.yandex.stockpile.internal.api.TUnassignShardResponse;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileBalancerServiceGrpc
    extends TStockpileBalancerServiceGrpc.TStockpileBalancerServiceImplBase
    implements InternalGrpcService
{
    private final StockpileLocalShardsState localShards;

    public StockpileBalancerServiceGrpc(StockpileLocalShardsState localShards) {
        this.localShards = localShards;
    }

    @Override
    public void ping(TPingRequest request, StreamObserver<TPingResponse> responseObserver) {
        StreamObservers.asyncComplete(localShards.ping(request), responseObserver);
    }

    @Override
    public void assignShard(TAssignShardRequest request, StreamObserver<TAssignShardResponse> responseObserver) {
        StreamObservers.asyncComplete(localShards.assignShard(request), responseObserver);
    }

    @Override
    public void unassignShard(TUnassignShardRequest request, StreamObserver<TUnassignShardResponse> responseObserver) {
        StreamObservers.asyncComplete(localShards.unassignShard(request), responseObserver);
    }

    // temporary proxy to migrate to a better named grpc service
    public static class Proxy
        extends ru.yandex.stockpile.internal.api.StockpileBalancerServiceGrpc.StockpileBalancerServiceImplBase
        implements InternalGrpcService
    {
        private final StockpileBalancerServiceGrpc delegate;

        public Proxy(StockpileBalancerServiceGrpc delegate) {
            this.delegate = delegate;
        }

        @Override
        public void assignShard(TAssignShardRequest request, StreamObserver<TAssignShardResponse> responseObserver) {
            delegate.assignShard(request, responseObserver);
        }

        @Override
        public void unassignShard(TUnassignShardRequest request, StreamObserver<TUnassignShardResponse> responseObserver) {
            delegate.unassignShard(request, responseObserver);
        }

        @Override
        public void listAssignments(TListAssignmentsRequest request, StreamObserver<TListAssignmentsResponse> responseObserver) {
            delegate.listAssignments(request, responseObserver);
        }

        @Override
        public void ping(TPingRequest request, StreamObserver<TPingResponse> responseObserver) {
            delegate.ping(request, responseObserver);
        }
    }
}
