package ru.yandex.stockpile.kikimrKv;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.kikimr.proto.MsgbusKv;

/**
 * https://st.yandex-team.ru/SOLOMON-1839
 *
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public enum KvChannel {

    INLINE(MsgbusKv.TKeyValueRequest.EStorageChannel.INLINE),
    HDD(MsgbusKv.TKeyValueRequest.EStorageChannel.MAIN),
    SSD1(MsgbusKv.TKeyValueRequest.EStorageChannel.EXTRA),
    SSD2(MsgbusKv.TKeyValueRequest.EStorageChannel.EXTRA2), // EXTRA2
    SSD3(MsgbusKv.TKeyValueRequest.EStorageChannel.EXTRA3), // EXTRA3
    SSD4(MsgbusKv.TKeyValueRequest.EStorageChannel.EXTRA4), // EXTRA4
    ;

    private final MsgbusKv.TKeyValueRequest.EStorageChannel channel;

    KvChannel(MsgbusKv.TKeyValueRequest.EStorageChannel channel) {
        this.channel = channel;
    }

    public MsgbusKv.TKeyValueRequest.EStorageChannel getChannel() {
        return channel;
    }

}
