package ru.yandex.stockpile.kikimrKv;

import java.util.stream.IntStream;

/**
 * @author Stepan Koltsov
 */
public class ShardIdMapToLong {

    private final long[] values;

    public ShardIdMapToLong(long[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Expected shards: >= 0 but " + values.length);
        }
        this.values = values.clone();
    }

    public long[] getValues() {
        return values;
    }

    public IntStream shardIdStream() {
        return IntStream.rangeClosed(1, values.length);
    }

    public void set(int shardId, long value) {
        values[idx(shardId)] = value;
    }

    public long get(int shardId) {
        if (values.length < shardId) {
            return 0;
        }
        return values[idx(shardId)];
    }

    public long incrementAndGet(int shardId) {
        return ++values[idx(shardId)];
    }

    private static int idx(int shardId) {
        return shardId - 1;
    }
}
