package ru.yandex.stockpile.memState;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.archive.MetricArchiveImmutable;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.stockpile.server.shard.iter.MetricsIterator;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public record MetricIdAndData(long localId, long lastTsMillis, long decimatedAt, MetricArchiveImmutable archive)
        implements MemMeasurable, AutoCloseable
{
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(MetricsIterator.class);

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE + archive.memorySizeIncludingSelf();
    }

    @Override
    public void close() {
        archive.close();
    }
}
