package ru.yandex.stockpile.server;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.collection.CollectorsF;
import ru.yandex.solomon.util.collection.Collectors2;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ListOfOptional<A> {

    @Nonnull
    private final A[] array;

    public ListOfOptional(@Nonnull A[] array) {
        this.array = array;
    }

    public A getOrNull(int index) {
        return array[index];
    }

    public Optional<A> get(int index) {
        return Optional.ofNullable(getOrNull(index));
    }

    private Stream<A> streamOfNullables() {
        return Arrays.stream(array);
    }

    private Stream<Optional<A>> stream() {
        return streamOfNullables().map(Optional::ofNullable);
    }

    public Optional<A> single() {
        return stream().collect(CollectorsF.single());
    }

    public boolean anyNulls() {
        return streamOfNullables().anyMatch(a -> a == null);
    }

    public boolean allNulls() {
        return streamOfNullables().allMatch(a -> a == null);
    }

    @Nonnull
    public A[] getAllNoNulls() {
        if (anyNulls()) {
            throw new IllegalStateException("got nulls");
        }
        return array;
    }

    public int size() {
        return array.length;
    }

    public static <A> Collector<A, ?, ListOfOptional<A>> collectorOfNullables(IntFunction<A[]> array) {
        return Collectors.collectingAndThen(Collectors2.toArray(array), ListOfOptional::new);
    }
}
