package ru.yandex.stockpile.server;

import java.time.Clock;

import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.TKikimrClientConfig;
import ru.yandex.solomon.locks.dao.LocksDao;
import ru.yandex.solomon.locks.dao.ydb.YdbLocksDao;
import ru.yandex.solomon.selfmon.mon.DaoMetricsProxy;

/**
 * List of DAO classes used by stockpile
 *
 * @author Vladimir Gordiychuk
 */
@Import(StockpileKikimrClientContext.class)
@Configuration
public class StockpileKikimrPersistenceContext {

    @Bean
    LocksDao locksDao(
        @Qualifier("KikimrClientConfig") TKikimrClientConfig config,
        TableClient tableClient,
        Clock clock,
        MetricRegistry registry)
    {
        var rootPath = config.getSchemaRoot() + "/Stockpile/V1";
        YdbLocksDao dao = new YdbLocksDao(tableClient, clock, rootPath);
        return DaoMetricsProxy.of(dao, LocksDao.class, registry);
    }
}
