package ru.yandex.stockpile.server;

import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.solomon.codec.bits.BitBufAllocator;
import ru.yandex.solomon.config.thread.LazyThreadPoolProvider;
import ru.yandex.solomon.ctx.ServiceAuthContext;
import ru.yandex.solomon.http.filters.RequestLoggingFilter;
import ru.yandex.solomon.selfmon.GeneralMonitoringContext;
import ru.yandex.solomon.selfmon.mon.SelfMetricsController;
import ru.yandex.solomon.staffOnly.StaffOnlyController;
import ru.yandex.solomon.staffOnly.StaffOnlyRedirectController;
import ru.yandex.solomon.tracing.TracingContext;
import ru.yandex.stockpile.api.grpc.StockpileGrpcServerContext;
import ru.yandex.stockpile.server.shard.LogStateOptions;
import ru.yandex.stockpile.server.shard.StockpileContext;
import ru.yandex.stockpile.server.shard.StockpileMemory;
import ru.yandex.stockpile.server.shard.StockpileShardMetricSupplier;

/**
 * @author Sergey Polovko
 */
@Import({
        RequestLoggingFilter.class,
        StockpileGrpcServerContext.class,
        StockpileContext.class,
        SelfMetricsController.class,
        StaffOnlyController.class,
        StaffOnlyRedirectController.class,
        LazyThreadPoolProvider.class,
        GeneralMonitoringContext.class,
        StockpileShardMetricSupplier.class,
        StockpileProjects.class,
        StockpileMemory.class,
        LogStateOptions.class,
        ServiceAuthContext.class,
        BitBufAllocator.class,
        TracingContext.class,
})
@Configuration
public class StockpileMainContext {
}
