package ru.yandex.stockpile.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.springframework.stereotype.Component;

import ru.yandex.solomon.staffOnly.annotations.LinkedOnRootPage;
import ru.yandex.solomon.staffOnly.annotations.ManagerMethod;
import ru.yandex.solomon.staffOnly.manager.special.ExtraContent;
import ru.yandex.stockpile.api.EProjectId;

/**
 * @author Vladimir Gordiychuk
 */
@Component
@LinkedOnRootPage("Projects manager")
public class StockpileProjects {
    private static final ConcurrentMap<EProjectId, Boolean> deleteDataStatus = new ConcurrentHashMap<>();

    public static boolean shouldBeDropped(EProjectId projectId) {
        switch (projectId) {
            case SOLOMON:
            case GRAPHITE:
                return false;
            default:
                return deleteDataStatus.getOrDefault(projectId, Boolean.FALSE);
        }
    }

    @ManagerMethod
    private void deleteData(String projectId) {
        deleteDataStatus.put(EProjectId.valueOf(projectId.toUpperCase()), Boolean.TRUE);
    }

    @ManagerMethod
    private void stopDeleteData(String projectId) {
        deleteDataStatus.put(EProjectId.valueOf(projectId.toUpperCase()), Boolean.FALSE);
    }

    @ExtraContent("Status by project")
    private Map<EProjectId, Boolean> extra() {
        return deleteDataStatus;
    }

    @ManagerMethod
    public void stopDeleteData() {
        deleteDataStatus.clear();
    }

    @Override
    public String toString() {
        return deleteDataStatus.toString();
    }
}
