package ru.yandex.stockpile.server;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class Txn {

    public static final long INVALID = -1;
    public static final long ZERO = 0;

    private final long txn;

    public Txn(long txn) {
        validateTxn(txn);
        this.txn = txn;
    }

    public long getTxn() {
        return txn;
    }

    public static void validateTxn(long txn) {
        if (txn <= 0) {
            throw new IllegalArgumentException("invalid txn: " + txn);
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Txn txn1 = (Txn) o;

        return txn == txn1.txn;

    }

    @Override
    public int hashCode() {
        return Long.hashCode(txn);
    }

    @Override
    public String toString() {
        return Long.toString(txn);
    }
}
