package ru.yandex.stockpile.server.data.chunk;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.names.FileNamePrefix;
import ru.yandex.stockpile.server.data.names.StockpileKvNames;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ChunkAddressGlobal {

    @Nonnull
    private final SnapshotLevel level;
    private final long snapshotTxn;
    private final int chunkNo;

    public ChunkAddressGlobal(SnapshotLevel level, long snapshotTxn, int chunkNo) {
        this.level = level;
        this.snapshotTxn = snapshotTxn;
        this.chunkNo = chunkNo;
    }

    public ChunkAddressGlobal(SnapshotAddress snapshot, int chunkNo) {
        this(snapshot.level(), snapshot.txn(), chunkNo);
    }

    @Nonnull
    public SnapshotLevel getLevel() {
        return level;
    }

    public long getSnapshotTxn() {
        return snapshotTxn;
    }

    public int getChunkNo() {
        return chunkNo;
    }

    @Override
    public String toString() {
        return StockpileKvNames.chunkFileName(
            level,
            snapshotTxn,
            chunkNo,
            FileNamePrefix.Current.instance);
    }
}
