package ru.yandex.stockpile.server.data.chunk;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ChunkIndexEntry {

    private final int chunkNo;
    private final long metricId;
    private final long lastTsMillis;
    private final int offset;
    private final int size;

    public ChunkIndexEntry(int chunkNo, long metricId, long lastTsMillis, int offset, int size) {
        this.chunkNo = chunkNo;
        this.metricId = metricId;
        this.lastTsMillis = lastTsMillis;
        this.offset = offset;
        this.size = size;
    }

    public int getChunkNo() {
        return chunkNo;
    }

    public long getMetricId() {
        return metricId;
    }

    public long getLastTsMillis() {
        return lastTsMillis;
    }

    public int getOffset() {
        return offset;
    }

    public int getSize() {
        return size;
    }

    public DataRangeInSnapshot getDataRange() {
        return new DataRangeInSnapshot(chunkNo, new DataRange(offset, size));
    }

    @Override
    public String toString() {
        return "ChunkIndexEntry{" +
            "chunkNo=" + chunkNo +
            ", metricId=" + metricId +
            ", lastTsMillis=" + lastTsMillis +
            ", offset=" + offset +
            ", size=" + size +
            '}';
    }
}
