package ru.yandex.stockpile.server.data.chunk;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.SelfContainedSerializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public final class ChunkIndexSerializer {

    public static SelfContainedSerializer<ChunkIndex> forFormat(StockpileFormat format) {
        return new V2();
    }

    /**
     * NEW IMPLEMENTATION
     */
    private static final class V2 implements SelfContainedSerializer<ChunkIndex> {
        @Override
        public void serializeWithLength(ChunkIndex chunkIndex, StockpileSerializer serializer) {
            serializer.writeFixed32(chunkIndex.metricCount());
            for (int i = 0; i < chunkIndex.metricCount(); ++i) {
                serializer.writeFixed64(chunkIndex.getLocalIdsSortedArray()[i]);
                serializer.writeFixed64(chunkIndex.getLastTssMillisArray()[i]);
                serializer.writeFixed32(chunkIndex.getSize(i));
            }
        }

        @Override
        public ChunkIndex deserializeWithLength(StockpileDeserializer deserializer) {
            int size = deserializer.readFixed32();
            ChunkIndex r = new ChunkIndex(size);
            for (int i = 0; i < size; ++i) {
                final long localId = deserializer.readFixed64();
                final long lastTsMillis = deserializer.readFixed64();
                final int dataSize = deserializer.readFixed32();
                r.addMetric(localId, lastTsMillis, dataSize);
            }
            return r;
        }
    }
}
