package ru.yandex.stockpile.server.data.chunk;

import java.util.NoSuchElementException;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.archive.MetricArchiveImmutable;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.codec.serializer.naked.NakedDeserializer;
import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.memState.MetricIdAndData;
import ru.yandex.stockpile.server.data.index.SnapshotIndexContentSerializer;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ChunkIterator {

    private final ChunkAddressGlobal address;
    private final ChunkIndex index;
    private final long decimatedAt;
    private final byte[] chunk;
    private final NakedDeserializer<MetricArchiveImmutable> dataSerializer;

    public ChunkIterator(ChunkAddressGlobal address, ChunkIndex index, long decimatedAt, byte[] chunk, StockpileFormat indexFormat) {
        this.address = address;
        this.index = index;
        this.decimatedAt = decimatedAt;
        this.chunk = chunk;
        this.dataSerializer = SnapshotIndexContentSerializer.dataDeserializerForVersionSealed(indexFormat);
    }

    private int pos;
    private int offset;

    public boolean hasNext() {
        return pos < index.metricCount();
    }

    public MetricIdAndData next() {
        if (!hasNext()) {
            throw new NoSuchElementException("No more metrics at chunk: " + address);
        }

        long localId = index.getLocalIdsSortedArray()[pos];
        int size = index.getSize(pos);
        long lastTsMillis = index.getLastTssMillisArray()[pos];
        try {
            MetricIdAndData r = new MetricIdAndData(
                localId,
                lastTsMillis,
                decimatedAt,
                dataSerializer.deserializeRange(chunk, offset, size));

            ++pos;
            offset += size;

            return r;
        } catch (Throwable e) {
            throw new RuntimeException("Chunk " + address.toString() + " localId: " + StockpileLocalId.toString(localId), e);
        }
    }
}
