package ru.yandex.stockpile.server.data.chunk;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ChunkWithNo implements MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(ChunkWithNo.class);

    private final int no;
    private final byte[] content;

    public ChunkWithNo(int no, byte[] content) {
        this.no = no;
        this.content = content;
    }

    public int getNo() {
        return no;
    }

    public byte[] getContent() {
        return content;
    }

    @Override
    public String toString() {
        return "ChunkWithNo{" +
                "no=" + no +
                ", bytes=" + content.length +
                '}';
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE + MemoryCounter.arrayObjectSize(content);
    }
}
