package ru.yandex.stockpile.server.data.chunk;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class DataRange {

    private final int offset;
    private final int length;

    public DataRange(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public int getOffset() {
        return offset;
    }

    public int getLength() {
        return length;
    }

    public static DataRange all() {
        return new DataRange(0, -1);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DataRange dataRange = (DataRange) o;

        if (offset != dataRange.offset) return false;
        return length == dataRange.length;

    }

    @Override
    public int hashCode() {
        int result = offset;
        result = 31 * result + length;
        return result;
    }

    @Override
    public String toString() {
        return offset + ":+" + length;
    }
}
