package ru.yandex.stockpile.server.data.chunk;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.stockpile.server.SnapshotLevel;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class DataRangeGlobal {
    @Nonnull
    private final SnapshotLevel level;
    private final long snapshotTxn;
    @Nonnull
    private final StockpileFormat indexFormat;
    @Nonnull
    private final DataRangeInSnapshot dataRangeInSnapshot;

    public DataRangeGlobal(SnapshotLevel level, long snapshotTxn, StockpileFormat indexFormat, DataRangeInSnapshot dataRangeInSnapshot) {
        this.level = level;
        this.snapshotTxn = snapshotTxn;
        this.indexFormat = indexFormat;
        this.dataRangeInSnapshot = dataRangeInSnapshot;
    }

    @Nonnull
    public SnapshotLevel getLevel() {
        return level;
    }

    @Nonnull
    public StockpileFormat getIndexFormat() {
        return indexFormat;
    }

    @Nonnull
    public SnapshotAddress snapshotAddress() {
        return new SnapshotAddress(level, snapshotTxn);
    }

    public long getSnapshotTxn() {
        return snapshotTxn;
    }

    public int getChunkNo() {
        return dataRangeInSnapshot.getChunkNo();
    }

    public int getOffset() {
        return dataRangeInSnapshot.getDataRange().getOffset();
    }

    public int getLength() {
        return dataRangeInSnapshot.getDataRange().getLength();
    }

    @Nonnull
    public DataRangeInSnapshot getDataRangeInSnapshot() {
        return dataRangeInSnapshot;
    }

    @Nonnull
    public ChunkAddressGlobal chunk() {
        return new ChunkAddressGlobal(level, snapshotTxn, getChunkNo());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DataRangeGlobal that = (DataRangeGlobal) o;

        if (snapshotTxn != that.snapshotTxn) return false;
        if (level != that.level) return false;
        if (indexFormat != that.indexFormat) return false;
        return dataRangeInSnapshot.equals(that.dataRangeInSnapshot);

    }

    @Override
    public int hashCode() {
        int result = level.hashCode();
        result = 31 * result + (int) (snapshotTxn ^ (snapshotTxn >>> 32));
        result = 31 * result + indexFormat.hashCode();
        result = 31 * result + dataRangeInSnapshot.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "DataRangeGlobal{" +
            "level=" + level +
            ", snapshotTxn=" + snapshotTxn +
            ", indexFormat=" + indexFormat +
            ", dataRangeInSnapshot=" + dataRangeInSnapshot +
            '}';
    }
}
