package ru.yandex.stockpile.server.data.chunk;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class DataRangeInSnapshot {
    private final int chunkNo;
    @Nonnull
    private final DataRange dataRange;

    public DataRangeInSnapshot(int chunkNo, DataRange dataRange) {
        this.chunkNo = chunkNo;
        this.dataRange = dataRange;
    }

    public int getChunkNo() {
        return chunkNo;
    }

    @Nonnull
    public DataRange getDataRange() {
        return dataRange;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DataRangeInSnapshot that = (DataRangeInSnapshot) o;

        if (chunkNo != that.chunkNo) return false;
        return dataRange.equals(that.dataRange);

    }

    @Override
    public int hashCode() {
        int result = chunkNo;
        result = 31 * result + dataRange.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "DataRangeInSnapshot{" +
            "chunkNo=" + chunkNo +
            ", dataRange=" + dataRange +
            '}';
    }
}
