package ru.yandex.stockpile.server.data.chunk;

import javax.annotation.Nonnull;

import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.stockpile.server.SnapshotLevel;

/**
 * @author Vladimir Gordiychuk
 */
public class IndexEntry {
    @Nonnull
    private final StockpileFormat format;
    @Nonnull
    private final SnapshotLevel level;
    private final long txn;
    private ChunkIndexEntry chunk;

    public IndexEntry(@Nonnull StockpileFormat format, @Nonnull SnapshotLevel level, long txn, ChunkIndexEntry chunk) {
        this.format = format;
        this.level = level;
        this.txn = txn;
        this.chunk = chunk;
    }

    public long getLastTsMillis() {
        return chunk.getLastTsMillis();
    }

    public DataRangeGlobal getDataRange() {
        return new DataRangeGlobal(level, txn, format, chunk.getDataRange());
    }

    @Override
    public String toString() {
        return "IndexEntry{" +
            "format=" + format +
            ", level=" + level +
            ", txn=" + txn +
            ", chunk=" + chunk +
            '}';
    }
}
