package ru.yandex.stockpile.server.data.chunk;

import java.util.List;

/**
 * @author Vladimir Gordiychuk
 */
public class IndexRangeResult {
    private final List<IndexEntry> entries;
    private final long fromTimeMillis;

    public IndexRangeResult(List<IndexEntry> entries, long fromTimeMillis) {
        this.entries = entries;
        this.fromTimeMillis = fromTimeMillis;
    }

    public List<IndexEntry> getEntries() {
        return entries;
    }

    public DataRangeGlobal[] getRanges() {
        return entries.stream()
            .map(IndexEntry::getDataRange)
            .toArray(DataRangeGlobal[]::new);
    }

    public long getFromTimeMillis() {
        return fromTimeMillis;
    }

    @Override
    public String toString() {
        return "IndexRangeResult{" +
            "entries=" + entries +
            ", fromTimeMillis=" + fromTimeMillis +
            '}';
    }
}
