package ru.yandex.stockpile.server.data.chunk;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.stockpile.server.SnapshotLevel;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public record SnapshotAddress(SnapshotLevel level, long txn) implements Comparable<SnapshotAddress>, MemMeasurable {
    public static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(SnapshotAddress.class);

    @Override
    public String toString() {
        return level + "/" + txn;
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE;
    }

    @Override
    public int compareTo(SnapshotAddress o) {
        return Long.compareUnsigned(txn, o.txn);
    }
}
