package ru.yandex.stockpile.server.data.command;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.solomon.codec.serializer.naked.NakedSerializer;
import ru.yandex.stockpile.server.data.chunk.SnapshotAddress;
import ru.yandex.stockpile.server.data.names.LongFileType;
import ru.yandex.stockpile.server.data.names.file.CommandFile;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public enum LongFileTypeSnapshotCommand implements LongFileType<
        SnapshotAddress,
        SnapshotCommand,
        SnapshotCommandContent,
        SnapshotCommandPartsSerialized,
        CommandFile>
{
    I;

    @Override
    public NakedSerializer<SnapshotCommandContent> serializer() {
        return SnapshotCommandContentSerializer.S;
    }

    @Override
    public SnapshotCommandPartsSerialized packSerialized(SnapshotAddress key, ByteString[] parts) {
        return new SnapshotCommandPartsSerialized(key.level(), key.txn(), parts);
    }

    @Override
    public SnapshotCommandContent getContent(SnapshotCommand data) {
        return data.content();
    }

    @Override
    public SnapshotAddress getKey(SnapshotCommand data) {
        return data.snapshotAddress();
    }

    @Override
    public SnapshotAddress serializedPartsGetKey(SnapshotCommandPartsSerialized serialized) {
        return serialized.snapshotAddress();
    }

    @Override
    public CommandFile makeFileName(SnapshotAddress key, int part, boolean last) {
        return new CommandFile(key.level(), key.txn(), part, last);
    }
}
