package ru.yandex.stockpile.server.data.command;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.Txn;
import ru.yandex.stockpile.server.data.chunk.SnapshotAddress;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public record SnapshotCommand(SnapshotLevel level, long txn, SnapshotCommandContent content) implements MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(SnapshotCommand.class);

    public SnapshotCommand {
        Txn.validateTxn(txn);
    }

    @Nonnull
    public SnapshotAddress snapshotAddress() {
        return new SnapshotAddress(level, txn);
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE + content.memorySizeIncludingSelf();
    }
}
