package ru.yandex.stockpile.server.data.command;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.stockpile.server.data.DeletedShardSet;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public record SnapshotCommandContent(DeletedShardSet deletedShards) implements MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(SnapshotCommandContent.class);

    public boolean isEmpty() {
        return deletedShards.isEmpty();
    }

    @Override
    public long memorySizeIncludingSelf() {
        long size = SELF_SIZE;
        size += deletedShards.memorySizeIncludingSelf();
        return size;
    }
}
