package ru.yandex.stockpile.server.data.command;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.chunk.SnapshotAddress;
import ru.yandex.stockpile.server.data.names.PartsSerialized;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public record SnapshotCommandPartsSerialized(SnapshotLevel level, long txn, ByteString[] content) implements PartsSerialized, MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(SnapshotCommandPartsSerialized.class);

    @Nonnull
    @Override
    public ByteString[] getContent() {
        return content;
    }

    public int contentSize() {
        int result = 0;
        for (var part : content) {
            result += part.size();
        }
        return result;
    }

    public SnapshotAddress snapshotAddress() {
        return new SnapshotAddress(level, txn);
    }

    @Override
    public long memorySizeIncludingSelf() {
        long size = SELF_SIZE;
        size += MemoryCounter.arrayObjectSize(content);
        for (ByteString chunk : content) {
            size += MemoryCounter.byteStringSize(chunk);
        }
        return size;
    }
}
