package ru.yandex.stockpile.server.data.dao;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.primitives.LazyGaugeInt64;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
class ReadBatcherMetrics {
    final GaugeInt64 inQueue;
    final Rate started;
    final Rate completed;
    final Rate failed;
    final Rate timeout;
    final LazyGaugeInt64 inFlight;
    final Histogram elapsedTimeMillis;

    public ReadBatcherMetrics(MetricRegistry registry) {
        inQueue = registry.gaugeInt64("kikimrKvClient.batch.read.chunks.inQueue");
        started = registry.rate("kikimrKvClient.batch.read.chunks.started");
        completed = registry.rate("kikimrKvClient.batch.read.chunks.completed");
        failed = registry.rate("kikimrKvClient.batch.read.chunks.failed");
        timeout = registry.rate("kikimrKvClient.batch.read.chunks.timeout");
        inFlight = registry.lazyGaugeInt64("kikimrKvClient.batch.read.chunks.inFlight", () -> {
            return started.get() - completed.get() - failed.get() - timeout.get();
        });
        elapsedTimeMillis = registry.histogramRate("kikimrKvClient.read.batcher.chunks.elapsedTimeMs",
                Histograms.exponential(13, 2, 16));
    }
}
