package ru.yandex.stockpile.server.data.dao;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.kikimr.client.kv.KikimrKvClient.KvEntryStats;
import ru.yandex.kikimr.client.kv.KvReadRangeResult;
import ru.yandex.kikimr.util.NameRange;
import ru.yandex.solomon.codec.archive.MetricArchiveImmutable;
import ru.yandex.stockpile.kikimrKv.counting.ReadClass;
import ru.yandex.stockpile.server.ListOfOptional;
import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.chunk.ChunkAddressGlobal;
import ru.yandex.stockpile.server.data.chunk.ChunkWithNo;
import ru.yandex.stockpile.server.data.chunk.DataRangeGlobal;
import ru.yandex.stockpile.server.data.chunk.SnapshotAddress;
import ru.yandex.stockpile.server.data.command.SnapshotCommandPartsSerialized;
import ru.yandex.stockpile.server.data.index.SnapshotIndexPartsSerialized;
import ru.yandex.stockpile.server.data.log.StockpileLogEntrySerialized;
import ru.yandex.stockpile.server.data.names.FileNamePrefix;


/**
 * @author Sergey Polovko
 *
 * TODO: delete KvEntryStats and KvReadRangeResult
 */
public interface StockpileShardStorage {

    long getGeneration();

    CompletableFuture<Void> lock();

    CompletableFuture<Void> writeLogEntry(StockpileLogEntrySerialized serialized);

    CompletableFuture<Void> writeLogSnapshot(long firstLogTxn, StockpileLogEntrySerialized serialized);

    CompletableFuture<Void> writeSnapshotChunkToTemp(SnapshotLevel level, long txn, ChunkWithNo chunkWithNo);

    CompletableFuture<Void> writeSnapshotIndexToTemp(SnapshotIndexPartsSerialized parts);

    CompletableFuture<Void> writeSnapshotCommandToTemp(SnapshotCommandPartsSerialized parts);

    CompletableFuture<Void> writeProducerSeqNoSnapshot(byte[] snapshot);

    CompletableFuture<Void> deleteTempFiles();

    CompletableFuture<Void> renameSnapshotDeleteLogs(SnapshotAddress address);

    CompletableFuture<Void> renameSnapshotDeleteOld(
            SnapshotAddress[] renameSnapshots,
            SnapshotAddress[] deleteSnapshots);

    CompletableFuture<byte[]> readChunk(ReadClass readClass, ChunkAddressGlobal chunkAddress, FileNamePrefix prefix);

    CompletableFuture<List<KvEntryStats>> readRangeNames(ReadClass readClass, NameRange nameRange);

    CompletableFuture<Optional<byte[]>> readData(ReadClass readClass, String name);

    CompletableFuture<ListOfOptional<MetricArchiveImmutable>> readSnapshotRanges(DataRangeGlobal[] ranges);

    CompletableFuture<Optional<MetricArchiveImmutable>> readSnapshotRange(DataRangeGlobal range);

    CompletableFuture<Void> flushReadQueue();

    CompletableFuture<KvReadRangeResult> readRange(ReadClass readClass, NameRange nameRange);
}
