package ru.yandex.stockpile.server.data.index;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.solomon.codec.serializer.naked.NakedSerializer;
import ru.yandex.stockpile.server.data.chunk.SnapshotAddress;
import ru.yandex.stockpile.server.data.names.LongFileType;
import ru.yandex.stockpile.server.data.names.file.IndexFile;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public enum LongFileTypeSnapshotIndex implements LongFileType<
        SnapshotAddress,
        SnapshotIndex,
        SnapshotIndexContent,
        SnapshotIndexPartsSerialized,
  IndexFile>
{
    I;

    @Override
    public NakedSerializer<SnapshotIndexContent> serializer() {
        return SnapshotIndexContentSerializer.S;
    }

    @Override
    public SnapshotIndexPartsSerialized packSerialized(SnapshotAddress key, ByteString[] parts) {
        return new SnapshotIndexPartsSerialized(key.level(), key.txn(), parts);
    }

    @Override
    public SnapshotIndexContent getContent(SnapshotIndex data) {
        return data.getContent();
    }

    @Override
    public SnapshotAddress getKey(SnapshotIndex data) {
        return data.snapshotAddress();
    }

    @Override
    public SnapshotAddress serializedPartsGetKey(SnapshotIndexPartsSerialized serialized) {
        return serialized.snapshotAddress();
    }

    @Override
    public IndexFile makeFileName(SnapshotAddress key, int part, boolean last) {
        return new IndexFile(key.level(), key.txn(), part, last);
    }
}
