package ru.yandex.stockpile.server.data.index;

import com.google.protobuf.WireFormat;

import ru.yandex.commune.protobuf5.Protobuf5Serializer;
import ru.yandex.commune.protobuf5.Protobuf5SerializerFactory;
import ru.yandex.misc.reflection.TypeX;
import ru.yandex.solomon.codec.serializer.naked.NakedSerializer;
import ru.yandex.solomon.codec.serializer.naked.NakedSerializerLookup;

/**
 * @author Stepan Koltsov
 */
public class Protobuf5SerializerFactorySolomon extends Protobuf5SerializerFactory {

    @Override
    public <A> Protobuf5Serializer<A> forType(TypeX type, WireFormat.FieldType actualFieldType, Class<?> replace) {
        if (type.sameAs(java.time.Instant.class)) {
            return forClass(long.class)
                .map(java.time.Instant::ofEpochMilli, java.time.Instant::toEpochMilli)
                .cast();
        }

        NakedSerializer<A> nakedSerializer = NakedSerializerLookup.lookupForVersionIndependentSerializer(type);
        if (nakedSerializer != null) {
            return forClass(byte[].class)
                .map(
                    nakedSerializer::deserializeFull,
                    nakedSerializer::serializeToBytes);
        }

        return super.forType(type, actualFieldType, replace);
    }
}
