package ru.yandex.stockpile.server.data.index;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.commune.protobuf5.Protobuf5Serializer;
import ru.yandex.solomon.codec.serializer.SelfContainedSerializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SelfContainedSerializerProtobuf5LengthDelimited<A> implements SelfContainedSerializer<A> {
    private final Protobuf5Serializer<A> protobuf5Serializer;

    public SelfContainedSerializerProtobuf5LengthDelimited(Protobuf5Serializer<A> protobuf5Serializer) {
        this.protobuf5Serializer = protobuf5Serializer;
    }

    @Override
    public void serializeWithLength(A a, StockpileSerializer serializer) {
        protobuf5Serializer.serializeLengthDelimited(a, serializer.asOutputStream());
    }

    @Override
    public A deserializeWithLength(StockpileDeserializer deserializer) {
        return protobuf5Serializer.deserializeLengthDelimited(deserializer.getCodedInputStream());
    }
}
