package ru.yandex.stockpile.server.data.index;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.archive.MetricArchiveImmutable;
import ru.yandex.solomon.codec.archive.serializer.MetricArchiveNakedSerializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.codec.serializer.WithVersionHeaderSerializer;
import ru.yandex.solomon.codec.serializer.array.ArrayNakedSerializer;
import ru.yandex.solomon.codec.serializer.naked.NakedDeserializer;
import ru.yandex.solomon.codec.serializer.naked.NakedSerializer;
import ru.yandex.stockpile.server.data.chunk.ChunkIndex;
import ru.yandex.stockpile.server.data.chunk.ChunkIndexSerializer;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SnapshotIndexContentSerializer {
    // TODO: drop protobuf5 from every where (gordiychuk@)
    private static final SelfContainedSerializerProtobuf5LengthDelimited<SnapshotIndexProperties> indexPropertiesSer =
        new SelfContainedSerializerProtobuf5LengthDelimited<>(new Protobuf5SerializerFactorySolomon().forClass(SnapshotIndexProperties.class));

    private static class Inner implements NakedSerializer<SnapshotIndexContent> {

        private final StockpileFormat format;
        private final ArrayNakedSerializer<ChunkIndex> chunksSerializer;

        public Inner(StockpileFormat format) {
            this.format = format;
            chunksSerializer = new ArrayNakedSerializer<>(ChunkIndex.class, ChunkIndexSerializer.forFormat(format));
        }

        @Override
        public void serializeToEof(SnapshotIndexContent snapshotIndexContent, StockpileSerializer serializer) {
            if (format != snapshotIndexContent.getFormat()) {
                throw new IllegalStateException();
            }

            indexPropertiesSer.serializeWithLength(snapshotIndexContent.properties(), serializer);

            chunksSerializer.serializeToEof(snapshotIndexContent.getChunks(), serializer);
        }

        @Override
        public SnapshotIndexContent deserializeToEofImpl(StockpileDeserializer deserializer) {
            SnapshotIndexProperties properties = indexPropertiesSer.deserializeWithLength(deserializer);

            return new SnapshotIndexContent(
                format,
                properties,
                chunksSerializer.deserializeToEof(deserializer));
        }
    }

    public static NakedSerializer<SnapshotIndexContent> contentSerializerForFormat(StockpileFormat format) {
        return new Inner(format);
    }

    public static final NakedSerializer<SnapshotIndexContent> S = new WithVersionHeaderSerializer<>(
        SnapshotIndexContentSerializer::contentSerializerForFormat,
        SnapshotIndexContent::getFormat
    );

    public static NakedSerializer<MetricArchiveImmutable> dataSerializerForVersionSealed(StockpileFormat version) {
        return MetricArchiveNakedSerializer.serializerForFormatSealed(version);
    }

    public static NakedDeserializer<MetricArchiveImmutable> dataDeserializerForVersionSealed(StockpileFormat version) {
        return MetricArchiveNakedSerializer.serializerForFormatSealed(version);
    }

}
