package ru.yandex.stockpile.server.data.index;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.stockpile.server.SnapshotLevel;
import ru.yandex.stockpile.server.data.chunk.SnapshotAddress;
import ru.yandex.stockpile.server.data.names.PartsSerialized;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SnapshotIndexPartsSerialized implements PartsSerialized, MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(SnapshotIndexPartsSerialized.class);

    private final SnapshotLevel level;
    private final long txn;
    private final ByteString[] content;

    public SnapshotIndexPartsSerialized(SnapshotLevel level, long txn, ByteString[] content) {
        this.level = level;
        this.txn = txn;
        this.content = content;
    }

    public SnapshotLevel getLevel() {
        return level;
    }

    public long getTxn() {
        return txn;
    }

    @Nonnull
    @Override
    public ByteString[] getContent() {
        return content;
    }

    public SnapshotAddress snapshotAddress() {
        return new SnapshotAddress(level, txn);
    }

    @Override
    public long memorySizeIncludingSelf() {
        long size = SELF_SIZE;
        size += MemoryCounter.arrayObjectSize(content);
        for (ByteString chunk : content) {
            long s= MemoryCounter.byteStringSize(chunk);
            size += s;
        }
        return size;
    }
}
