package ru.yandex.stockpile.server.data.index;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.stockpile.server.data.index.stats.IndexStatsProject;
import ru.yandex.stockpile.server.shard.SnapshotReason;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class SnapshotIndexProperties {
    public static final SnapshotIndexProperties empty = new SnapshotIndexProperties();

    @ProtoField(n = 1)
    private long tsMillis;
    @ProtoField(n = 12)
    private long createDurationMillis;
    @ProtoField(n = 2)
    private long recordCount;
    @ProtoField(n = 3)
    private SnapshotReason snapshotReason;
    @ProtoField(n = 4)
    private long decimatedAt;

    @ProtoField(n = 13)
    public long metricCount;

    @ProtoField(n = 15)
    @Nullable
    private IndexStatsProject statsByProject;

    public SnapshotIndexProperties setCreatedAt(long tsMillis) {
        this.tsMillis = tsMillis;
        return this;
    }

    public SnapshotIndexProperties setDecimatedAt(long decimatedAt) {
        this.decimatedAt = decimatedAt;
        return this;
    }

    public SnapshotIndexProperties setCreateDurationMillis(long createDurationMillis) {
        this.createDurationMillis = createDurationMillis;
        return this;
    }

    public SnapshotIndexProperties setRecordCount(long recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public SnapshotIndexProperties setSnapshotReason(SnapshotReason snapshotReason) {
        this.snapshotReason = snapshotReason;
        return this;
    }

    public SnapshotIndexProperties setMetricCount(long metricCount) {
        this.metricCount = metricCount;
        return this;
    }

    public SnapshotIndexProperties setStatsByProject(@Nullable IndexStatsProject statsByProject) {
        this.statsByProject = statsByProject;
        return this;
    }

    public long getTsMillis() {
        return tsMillis;
    }

    public long getDecimatedAt() {
        return decimatedAt;
    }

    public long getCreateDurationMillis() {
        return createDurationMillis;
    }

    public long getRecordCount() {
        return recordCount;
    }

    @Nonnull
    public IndexStatsProject getStatsByProject() {
        return statsByProject != null ? statsByProject : new IndexStatsProject();
    }

    @Nonnull
    public SnapshotReason getSnapshotReason() {
        return snapshotReason != null ? snapshotReason : SnapshotReason.UNKNOWN;
    }
}
