package ru.yandex.stockpile.server.data.index.stats;

import java.util.StringJoiner;

import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.codec.archive.MetricArchiveGeneric;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;

/**
 * @author Vladimir Gordiychuk
 */
public class IndexStatsData implements MemMeasurable, MetricSupplier {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(IndexStatsData.class);

    @ProtoField(n = 1)
    public long records;
    @ProtoField(n = 2)
    public long metrics;
    @ProtoField(n = 3)
    public long bytes;

    public IndexStatsData() {
    }

    public void add(MetricArchiveGeneric archive) {
        this.bytes += archive.bytesCount();
        this.records += archive.getRecordCount();
        this.metrics += 1;
    }

    public void combine(IndexStatsData stats) {
        this.records += stats.records;
        this.metrics += stats.metrics;
        this.bytes += stats.bytes;
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", IndexStatsData.class.getSimpleName() + "[", "]")
            .add("records=" + records)
            .add("metrics=" + metrics)
            .add("bytes=" + bytes)
            .toString();
    }

    @Override
    public int estimateCount() {
        return 3;
    }

    @Override
    public void append(long tsMillis, Labels labels, MetricConsumer consumer) {
        append(tsMillis, labels, "stockpile.host.record.count", records, consumer);
        append(tsMillis, labels, "stockpile.host.sensors.count", metrics, consumer);
        append(tsMillis, labels, "stockpile.host.bytes.count", bytes, consumer);
    }

    private void append(long tsMillis, Labels commonLabels, String metric, long value, MetricConsumer consumer) {
        consumer.onMetricBegin(MetricType.IGAUGE);
        consumer.onLabelsBegin(commonLabels.size() + 1);
        commonLabels.forEach(consumer::onLabel);
        consumer.onLabel("sensor", metric);
        consumer.onLabelsEnd();
        consumer.onLong(tsMillis, value);
        consumer.onMetricEnd();
    }
}
