package ru.yandex.stockpile.server.data.index.stats;

import javax.annotation.ParametersAreNonnullByDefault;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

import ru.yandex.commune.protobuf5.Protobuf5Serializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.codec.serializer.naked.NakedSerializer;
import ru.yandex.stockpile.server.data.index.SelfContainedSerializerProtobuf5LengthDelimited;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SerializerForIndexStatsOwner implements NakedSerializer<IndexStatsOwner> {
    private static final SelfContainedSerializerProtobuf5LengthDelimited<IndexStatsType> kindStats =
        new SelfContainedSerializerProtobuf5LengthDelimited<>(Protobuf5Serializer.cons(IndexStatsType.class));

    @Override
    public void serializeToEof(IndexStatsOwner indexStatsOwner, StockpileSerializer serializer) {
        var map = indexStatsOwner.getByOwner();
        serializer.writeVarint32(map.size());
        for (var entry : map.int2ObjectEntrySet()) {
            serializer.writeVarint32(entry.getIntKey());
            kindStats.serializeWithLength(entry.getValue(), serializer);
        }
    }

    @Override
    public IndexStatsOwner deserializeToEofImpl(StockpileDeserializer deserializer) {
        var size = deserializer.readVarint32();
        Int2ObjectMap<IndexStatsType> stats = new Int2ObjectOpenHashMap<>();
        for (int index = 0; index < size; index++) {
            int key = deserializer.readVarint32();
            IndexStatsType value = kindStats.deserializeWithLength(deserializer);
            stats.put(key, value);
        }

        return new IndexStatsOwner(stats);
    }
}
