package ru.yandex.stockpile.server.data.log;

/**
 * @author Stepan Koltsov
 */
public enum LogReason {
    UNKNOWN(0),
    TX(1),
    LS_TOO_MANY_LOGS(5),
    LS_EXPLICITLY_REQUESTED(6),
    LS_TOO_LARGE_SINCE_LAST(7),
    ;

    private final int value;

    LogReason(int value) {
        this.value = value;
    }

    public int value() {
        return value;
    }

    public static LogReason fromValue(int value) {
        switch (value) {
            case 1: return TX;
            case 5: return LS_TOO_MANY_LOGS;
            case 6: return LS_EXPLICITLY_REQUESTED;
            case 7: return LS_TOO_LARGE_SINCE_LAST;
            default: return UNKNOWN;
        }
    }
}
