package ru.yandex.stockpile.server.data.log;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.solomon.codec.serializer.naked.NakedSerializer;
import ru.yandex.stockpile.server.Txn;
import ru.yandex.stockpile.server.data.names.LongFileType;
import ru.yandex.stockpile.server.data.names.file.LogFile;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public enum LongFileTypeLogEntry implements LongFileType<
        Txn,
        StockpileLogEntry,
        StockpileLogEntryContent,
        StockpileLogEntryPartsSerialized,
  LogFile>
{
    I;

    @Override
    public NakedSerializer<StockpileLogEntryContent> serializer() {
        return StockpileLogEntryContentSerializer.S;
    }

    @Override
    public StockpileLogEntryPartsSerialized packSerialized(Txn key, ByteString[] parts) {
        return new StockpileLogEntryPartsSerialized(key.getTxn(), parts);
    }

    @Override
    public StockpileLogEntryContent getContent(StockpileLogEntry data) {
        return data.getContent();
    }

    @Override
    public Txn getKey(StockpileLogEntry data) {
        return new Txn(data.getTxn());
    }

    @Override
    public Txn serializedPartsGetKey(StockpileLogEntryPartsSerialized serialized) {
        return new Txn(serialized.getTxn());
    }

    @Override
    public LogFile makeFileName(Txn key, int part, boolean last) {
        return new LogFile(key.getTxn(), part, last);
    }
}
