package ru.yandex.stockpile.server.data.log;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class StockpileLogEntry implements MemMeasurable, AutoCloseable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(StockpileLogEntry.class);

    private final long txn;
    private final StockpileLogEntryContent content;

    public StockpileLogEntry(long txn, StockpileLogEntryContent content) {
        this.txn = txn;
        this.content = content;
    }

    public long getTxn() {
        return txn;
    }

    public StockpileLogEntryContent getContent() {
        return content;
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE + content.memorySizeIncludingSelf();
    }

    @Override
    public String toString() {
        return "StockpileLogEntry{" +
            "txn=" + txn +
            ", content=" + content +
            '}';
    }

    @Override
    public void close() {
        content.release();
    }
}
