package ru.yandex.stockpile.server.data.log;

import javax.annotation.Nonnull;

import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;

import ru.yandex.solomon.codec.archive.MetricArchiveImmutable;
import ru.yandex.stockpile.server.data.DeletedShardSet;

/**
 * @author Vladimir Gordiychuk
 */
public class StockpileLogEntryContentImmutable {
    private final Long2ObjectMap<MetricArchiveImmutable> dataByMetricId;
    private final Int2LongMap producerSeqNoById;
    private final DeletedShardSet deletedShards;

    public StockpileLogEntryContentImmutable(Long2ObjectMap<MetricArchiveImmutable> dataByMetricId, DeletedShardSet deletedShards, Int2LongMap producerSeqNoById) {
        this.dataByMetricId = dataByMetricId;
        this.deletedShards = deletedShards;
        this.producerSeqNoById = producerSeqNoById;
    }

    public StockpileLogEntryProperties properties() {
        return new StockpileLogEntryProperties(dataByMetricId.size());
    }

    public Long2ObjectMap<MetricArchiveImmutable> getDataByMetricId() {
        return dataByMetricId;
    }

    public Int2LongMap getProducerSeqNoById() {
        return producerSeqNoById;
    }

    public DeletedShardSet getDeletedShards() {
        return deletedShards;
    }

    public int getMetricCount() {
        return dataByMetricId.size();
    }

    @Nonnull
    public MetricArchiveImmutable archiveRefByLocalId(long localId) {
        MetricArchiveImmutable archive = dataByMetricId.get(localId);
        if (archive != null) {
            return archive;
        }

        return MetricArchiveImmutable.empty;
    }
}
