package ru.yandex.stockpile.server.data.log;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.stockpile.server.data.names.PartsSerialized;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class StockpileLogEntryPartsSerialized implements PartsSerialized, MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(StockpileLogEntryPartsSerialized.class);

    private final long txn;
    private final ByteString[] content;

    public StockpileLogEntryPartsSerialized(long txn, ByteString[] content) {
        this.txn = txn;
        this.content = content;
    }

    public long getTxn() {
        return txn;
    }

    @Override
    @Nonnull
    public ByteString[] getContent() {
        return content;
    }

    @Override
    public long memorySizeIncludingSelf() {
        long size = SELF_SIZE + MemoryCounter.arrayObjectSize(content);
        for (ByteString bytes : content) {
            size += MemoryCounter.byteStringSize(bytes);
        }
        return size;
    }
}
