package ru.yandex.stockpile.server.data.log;

import ru.yandex.solomon.codec.serializer.SelfContainedSerializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * NOTE: do not change code in serializer by itself. You must create a new version
 *       backward compatible with previous one.
 *
 * @author Sergey Polovko
 */
public interface StockpileLogEntryPropertiesSerializer extends SelfContainedSerializer<StockpileLogEntryProperties> {

    static StockpileLogEntryPropertiesSerializer makeSerializerFor(StockpileFormat format) {
        return new V2();
    }

    /**
     * Writes values in backward compatible format. So there are reserved gaps.
     */
    class V2 implements StockpileLogEntryPropertiesSerializer {
        @Override
        public StockpileLogEntryProperties deserializeWithLength(StockpileDeserializer deserializer) {
            int archivesCount = deserializer.readVarint32();
            deserializer.readVarint32(); // skip
            deserializer.readVarint32(); // skip
            deserializer.readVarint32(); // skip
            deserializer.readVarint32(); // skip
            return new StockpileLogEntryProperties(archivesCount);
        }

        @Override
        public void serializeWithLength(StockpileLogEntryProperties properties, StockpileSerializer serializer) {
            serializer.writeVarint32(properties.getArchivesCount());
            serializer.writeVarint32(0); // reserved
            serializer.writeVarint32(0); // reserved
            serializer.writeVarint32(0); // reserved
            serializer.writeVarint32(0); // reserved
        }
    }
}
