package ru.yandex.stockpile.server.data.log;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.solomon.codec.serializer.ByteStringsStockpile;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class StockpileLogEntrySerialized implements MemMeasurable {
    private static final long SELF_SELF = MemoryCounter.objectSelfSizeLayout(StockpileLogEntrySerialized.class);

    private final long txn;
    private final ByteString content;

    public StockpileLogEntrySerialized(long txn, byte[] content) {
        this.txn = txn;
        this.content = ByteStringsStockpile.unsafeWrap(content);
    }

    public StockpileLogEntrySerialized(long txn, ByteString content) {
        this.txn = txn;
        this.content = content;
    }

    public long getTxn() {
        return txn;
    }

    public int size() {
        return content.size();
    }

    public StockpileLogEntryPartsSerialized split() {
        ByteString[] split = ByteStringsStockpile.split(content, KikimrKvClient.DO_NOT_EXCEED_FILE_SIZE);
        return new StockpileLogEntryPartsSerialized(txn, split);
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SELF + MemoryCounter.byteStringSize(content);
    }

    @Override
    public String toString() {
        return "StockpileLogEntrySerialized{" +
            "txn=" + txn +
            ", content=" + content.size() +
            '}';
    }
}
