package ru.yandex.stockpile.server.data.log;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileFormat;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.codec.serializer.WithVersionHeaderSerializer;
import ru.yandex.solomon.codec.serializer.naked.NakedSerializer;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class StockpileProducerSeqNoSnapshotSerializer extends WithVersionHeaderSerializer<Int2LongMap> {
    public static final NakedSerializer<Int2LongMap> S =
            new StockpileProducerSeqNoSnapshotSerializer(StockpileFormat.CURRENT);

    StockpileProducerSeqNoSnapshotSerializer(StockpileFormat format) {
        super(StockpileProducerSeqNoSnapshotSerializer::serializerForFormat, e -> format);
    }

    @Nonnull
    public static NakedSerializer<Int2LongMap> serializerForFormat(StockpileFormat format) {
        return new V1();
    }

    private static class V1 implements NakedSerializer<Int2LongMap> {
        @Override
        public void serializeToEof(Int2LongMap snapshot, StockpileSerializer serializer) {
            serializer.writeVarint32(snapshot.size());
            for (var entry : snapshot.int2LongEntrySet()) {
                serializer.writeVarint32(entry.getIntKey());
                serializer.writeVarint64(entry.getLongValue());
            }
        }

        @Override
        public Int2LongMap deserializeToEofImpl(StockpileDeserializer deserializer) {
            int size = deserializer.readVarint32();
            Int2LongMap result = new Int2LongOpenHashMap(size);
            for (int index = 0; index < size; index++) {
                int producerId = deserializer.readVarint32();
                long producerSeqNo = deserializer.readVarint64();
                result.put(producerId, producerSeqNo);
            }
            return result;
        }
    }
}
