package ru.yandex.stockpile.server.data.names;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.stockpile.server.data.names.parserFormatter.ParserFormatter;
import ru.yandex.stockpile.server.data.names.parserFormatter.ParserFormatters;
import ru.yandex.stockpile.server.data.names.parserFormatter.TwoWayFunction;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class BigFilePart {

    private static final NumberNamePart numberNamePart = new NumberNamePart(5);

    public static final BigFilePart max = new BigFilePart(Math.toIntExact(numberNamePart.max), true);

    private final int no;
    private final boolean last;

    public BigFilePart(int no, boolean last) {
        this.no = no;
        this.last = last;
    }

    public int getNo() {
        return no;
    }

    public boolean isLast() {
        return last;
    }

    public static ParserFormatter<BigFilePart> dotSuffixPf() {
        return suffixPf().addPrefix(".");
    }

    public static ParserFormatter<BigFilePart> suffixPf() {
        return ParserFormatters.seq2(numberNamePart.integerParserFormatter(), ParserFormatters.bool("z", "y"))
            .map(new TwoWayFunction<Tuple2<Integer, Boolean>, BigFilePart>() {
                @Override
                public BigFilePart thatWay(Tuple2<Integer, Boolean> integerBooleanTuple2) {
                    return new BigFilePart(integerBooleanTuple2._1, integerBooleanTuple2._2);
                }

                @Override
                public Tuple2<Integer, Boolean> backwards(BigFilePart bigFilePart) {
                    return Tuple2.tuple(bigFilePart.no, bigFilePart.last);
                }
            });
    }

    public static String countSuffixToString(int count) {
        return ".{" + count + "}z";
    }

    @Override
    public String toString() {
        return suffixPf().format(this);
    }
}
