package ru.yandex.stockpile.server.data.names;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public enum FileKind {
    META_RECORD("meta"),
    LOG("logs"),
    LOG_SNAPSHOT("logs_snapshot"),
    TWO_HOUR_INDEX("2h_index"),
    TWO_HOUR_CHUNK("2h_chunk"),
    TWO_HOUR_COMMAND("2h_command"),
    DAILY_INDEX("daily_index"),
    DAILY_CHUNK("daily_chunk"),
    DAILY_COMMAND("daily_command"),
    ETERNITY_INDEX("eternity_index"),
    ETERNITY_CHUNK("eternity_chunk"),
    ETERNITY_COMMAND("eternity_command"),
    PRODUCER_SEQUENCES("producer_sequences"),
    TEMP("temp"),
    LOCK("lock"),
    UNKNOWN("unknown"),
    ;

    public final String monKey;

    FileKind(String monKey) {
        this.monKey = monKey;
    }

    public static FileKind classify(String fileName) {
        Optional<FileNameParsed> f = FileNameParsed.parseCurrentOptional(fileName);
        if (f.isPresent()) {
            return f.get().fileKind();
        }

        if (fileName.startsWith(StockpileKvNames.TMP_PREFIX)) {
            return TEMP;
        }

        if (fileName.equals(".lock")) {
            return LOCK;
        }

        return UNKNOWN;
    }
}
