package ru.yandex.stockpile.server.data.names;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.lang.Validate;
import ru.yandex.stockpile.server.Txn;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class InBackupFileNameSet {

    private final List<IndexAddressWithFileCount> indexes;
    private final List<LogAddressWithFileCount> logs;

    public InBackupFileNameSet(List<FileNameParsed> files) {
        indexes = IndexAddressWithFileCount.filter(files);
        logs = LogAddressWithFileCount.filter(files);

        Validate.isTrue(isSortedByTxn(logs));
    }

    private static boolean isSortedByTxn(List<LogAddressWithFileCount> logs) {
        for (int i = 1; i < logs.size(); i++) {
            long prev = logs.get(i - 1).getTxn();
            long curr = logs.get(i).getTxn();
            if (prev > curr) {
                return false;
            }
        }
        return true;
    }

    public List<IndexAddressWithFileCount> getIndexes() {
        return indexes;
    }

    public List<LogAddressWithFileCount> getLogs() {
        return logs;
    }

    public long lastTxn() {
        long max = Txn.ZERO;
        if (logs.size() > 0) {
            // logs already sorted by txn
            max = logs.get(logs.size() - 1).getTxn();
        }

        for (var index : indexes) {
            max = Math.max(max, index.getTxn());
        }

        return max;
    }
}
