package ru.yandex.stockpile.server.data.names;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.collection.GroupByFlat;
import ru.yandex.stockpile.server.Txn;
import ru.yandex.stockpile.server.data.names.file.LogFile;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class LogAddressWithFileCount {
    private final long txn;
    private final int count;

    public LogAddressWithFileCount(long txn, int count) {
        this.txn = txn;
        this.count = count;
    }

    public long getTxn() {
        return txn;
    }

    public Txn getTxnObject() {
        return new Txn(txn);
    }

    public int getCount() {
        return count;
    }

    public LogFile[] logFileNames() {
        return IntStream.range(0, count)
            .mapToObj(i -> new LogFile(txn, i, i == count - 1))
            .toArray(LogFile[]::new);
    }

    public static LogAddressWithFileCount fold1(List<LogFile> fileNamesSorted) {
        return NumberNamePart.fold1(fileNamesSorted, l -> new Txn(l.txn()), (txn, count) -> new LogAddressWithFileCount(txn.getTxn(), count));
    }

    public static List<LogAddressWithFileCount> fold(List<LogFile> logFileNamesSorted) {
        return GroupByFlat.groupBy(logFileNamesSorted, (a, b) -> a.txn() == b.txn())
            .stream()
            .map(LogAddressWithFileCount::fold1)
            .collect(Collectors.toList());
    }

    public static List<LogAddressWithFileCount> filter(List<FileNameParsed> files) {
        List<LogFile> logFiles = files.stream()
            .filter(f -> f instanceof LogFile)
            .map(f -> (LogFile) f)
            .collect(Collectors.toList());
        return fold(logFiles);
    }

    @Override
    public String toString() {
        return StockpileKvNames.LOG_PREFIX + StockpileKvNames.txnPart.format(txn) + BigFilePart.countSuffixToString(count);
    }
}
