package ru.yandex.stockpile.server.data.names;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.kikimr.proto.MsgbusKv;
import ru.yandex.solomon.codec.serializer.ByteStringsStockpile;
import ru.yandex.solomon.codec.serializer.naked.NakedSerializer;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface LongFileType<K, D, C, S extends PartsSerialized, F extends FileNameParsed> {

    NakedSerializer<C> serializer();

    S packSerialized(K key, ByteString[] parts);

    C getContent(D data);
    K getKey(D data);

    K serializedPartsGetKey(S serialized);

    F makeFileName(K key, int part, boolean last);

    default S serialize(D data) {
        ByteString bytes = serializer().serializeToByteString(getContent(data));
        ByteString[] parts = ByteStringsStockpile.split(bytes, KikimrKvClient.DO_NOT_EXCEED_FILE_SIZE);
        return packSerialized(getKey(data), parts);
    }

    default List<KikimrKvClient.Write> makeWrites(S partsSerialized,
        MsgbusKv.TKeyValueRequest.EStorageChannel storageChannel, MsgbusKv.TKeyValueRequest.EPriority priority)
    {
        ByteString[] parts = partsSerialized.getContent();
        K key = serializedPartsGetKey(partsSerialized);
        var writes = new ArrayList<KikimrKvClient.Write>(parts.length);
        for (int i = 0; i < parts.length; i++) {
            FileNameParsed fileName = makeFileName(key, i, i == parts.length - 1);
            var write = new KikimrKvClient.Write(fileName.reconstructCurrent(), parts[i], storageChannel, priority);
            writes.add(write);
        }
        return writes;
    }
}
