package ru.yandex.stockpile.server.data.names;

import java.util.Arrays;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.ByteString;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface PartsSerialized {

    @Nonnull
    ByteString[] getContent();

    default long sumLength() {
        return Arrays.stream(getContent()).mapToLong(ByteString::size).sum();
    }

}
