package ru.yandex.stockpile.server.data.names.file;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.stockpile.server.data.names.FileKind;
import ru.yandex.stockpile.server.data.names.FileNameParsed;
import ru.yandex.stockpile.server.data.names.StockpileKvNames;
import ru.yandex.stockpile.server.data.names.parserFormatter.ParserFormatter;
import ru.yandex.stockpile.server.data.names.parserFormatter.ParserFormatters;
import ru.yandex.stockpile.server.data.names.parserFormatter.TwoWayFunction;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class ProducerSeqNoFile extends FileNameParsed {
    public static final String FILE_NAME = "producer.sequences";
    public static final String CURRENT_FILE_NAME = StockpileKvNames.CURRENT_PREFIX + FILE_NAME;
    public static final ParserFormatter<ProducerSeqNoFile> pf = ParserFormatters.str(FILE_NAME)
            .map(new TwoWayFunction<>() {
                @Override
                public ProducerSeqNoFile thatWay(Void aVoid) {
                    return new ProducerSeqNoFile();
                }

                @Override
                public Void backwards(ProducerSeqNoFile producerSeqNoParsed) {
                    return null;
                }
            });

    @Nonnull
    @Override
    public FileKind fileKind() {
        return FileKind.PRODUCER_SEQUENCES;
    }

    @Nonnull
    @Override
    public String reconstructWithinBackup() {
        return FILE_NAME;
    }
}
